#ifndef BITS_H
#define BITS_H

#include "defs.h"
#include "squares.h"

#define FILEOPEN(occ, f) ( ( (file_masks[(f)]) & (occ) ) == 0)
#define RANKOCC(occ, r) ( ( (rank_masks[(r)]) & (occ) ) != 0)



extern u64 setter[64];
extern u64 clearer[64];
extern u64 isfilenorth[64];//is a bit set north of our bit... e.g on E4, is something on E5, E6, E7, E8
extern u64 isfilesouth[64];
extern u64 isisolated[64];
extern u64 whitepassed[64];
extern u64 blackpassed[64];


extern u64 rank_masks[8];
extern u64 file_masks[8];



extern void printbitboard(const u64 b);
extern void init_bitboards();
extern int POP(u64 &b);
extern int MSB(const u64 &b);
extern int LSB(const u64 &b);

inline void setbit(uint sq, u64 &bitbrd)
{
	ASS(onbrd(sq));
	ASS(sqto64(sq)>=0&&sqto64(sq)<64);
	bitbrd |= setter[sqto64(sq)];
}

inline void clearbit(uint sq, u64 &bitbrd)
{
	ASS(onbrd(sq));
	ASS(sqto64(sq)>=0&&sqto64(sq)<64);
	bitbrd &= clearer[sqto64(sq)];
}


inline void movebit(uint from, uint to, u64 &bitbrd)
{
	ASS(onbrd(from));
	ASS(onbrd(to));
	ASS(sqto64(from)>=0&&sqto64(from)<64);
	ASS(sqto64(to)>=0&&sqto64(to)<64);
	bitbrd &= clearer[sqto64(from)];
	bitbrd |= setter[sqto64(to)];
}


#endif
